# Methods for converting spectral database .csv file to file formats for linear spectral unmixing in Davinci.
# This script uses the "Multispectral_combined_data.csv" file from the "Spectral and Biological Archive
# of Multiple Microbial Mat Types Across Seven Meltwater Streams in Fryxell Basin, Taylor Valley, Antarctica (2018-2019)"
# data package. This script converts the .csv file to the file formats necessary for linear spectral unmixing in Davinci.
# Davinci requires an ASCII file of all reflectance data values and a .txt file with all column headers in a 1D array.
#
# Script Authors: Borges, S. R., Tai Udovicic, C. J.
# Used in publication: Modeling Areal Coverage of Microbial Mat and Moss Across the Fryxell Basin in the McMudro
# Dry Valleys, Borges et al. 2023
# Affiliated data package: Modeling Microbial Mat and Moss Across Streams in Fryxell Basin, Taylor Valley, 
# Antarctica (2018-2019)
#
# Imports tools
import numpy as np 
import pandas as pd
# Reads in data file
multi_lib = pd.read_csv('~/Multispectral_combined_data.csv')
# Creates empty array
hdrs = []
# Appends all column headers in the .csv file to the hdrs array and creates
for i in range (1, len(multi_lib.columns)):
    nm = multi_lib.columns[i]
    hdrs = np.append(hdrs, nm)
    speclib = pd.DataFrame(multi_lib[hdrs])
# Transposes the hdrs array to be a 1D array
hdrs = np.array(hdrs).transpose()
# Saves files
np.savetxt("multispectral_library", speclib, fmt='%s')
np.savetxt("multispectral_library_headers.txt", hdrs, fmt='%s')

