clear all; 
close all; 
clc; 

% read-in gridded met data files, and plot the data

year = [1995]; 
month = {'01','02','03','04','05','06','07','08','09','10','11','12'};
day = {'01','02','03','04','05','06','07','08','09','10','11','12','13',...
    '14','15','16','17','18','19','20','21','22','23','24','25','26',...
    '27','28','29','30','31'}; 
hour = {'00','02','06','06','08','10','12','14','16','18','20','22'};

% SPECIFY THE NORTHING AND EASTING OF THE LOWER LEFTHAND CORNER OF THE
% DOMAIN
xllcorner = -9999.9999984932; 
yllcorner = 19999.999993291; 
Yg = [yllcorner:250:yllcorner+(139*250)]; Xg = [xllcorner:250:xllcorner+(199*250)]; 

% LOOP THROUGH 1995 SIMULATED MM GENERATED DATA GRIDS, AND PLOT DATA AT EACH TIMESTEP 
k=0; 
for m = 1:length(month)
    if m == 1 || m == 3 || m == 5 || m == 7 || m == 8 || m == 10 || m == 12
    day = {'01','02','03','04','05','06','07','08','09','10','11','12','13',...
    '14','15','16','17','18','19','20','21','22','23','24','25','26',...
    '27','28','29','30','31'}; 
    elseif m == 2
    day = {'01','02','03','04','05','06','07','08','09','10','11','12','13',...
    '14','15','16','17','18','19','20','21','22','23','24','25','26',...
    '27','28'};   
    else
    day = {'01','02','03','04','05','06','07','08','09','10','11','12','13',...
    '14','15','16','17','18','19','20','21','22','23','24','25','26',...
    '27','28','29','30'};   
    end
        
for d = 1:length(day)
    
    
    for h = 1:length(hour)
        
    current_date = [year,str2num(month{m}),str2num(day{d}),str2num(hour{h}),0,0];
        
        filename_Qsi = strcat('Qsi_',num2str(year),'.',(month(m)),...
            '.',(day(d)),'.',(hour(h)),'.asc'); 
        filename_Tair = strcat('Tair_',num2str(year),'.',(month(m)),...
            '.',(day(d)),'.',(hour(h)),'.asc'); 
        filename_rh = strcat('rh_',num2str(year),'.',(month(m)),...
            '.',(day(d)),'.',(hour(h)),'.asc'); 
        filename_Qli = strcat('Qli_',num2str(year),'.',(month(m)),...
            '.',(day(d)),'.',(hour(h)),'.asc');
        filename_wspd = strcat('windspd_',num2str(year),'.',(month(m)),...
            '.',(day(d)),'.',(hour(h)),'.asc');
        
        if m ==1 & d == 1 & h == 1
            
        else
            
        k=k+1; 
        % CHANGE THE PATH DIRECTORY ACCORDING TO WHERE YOU HAVE THE DATA
        % SAVED.... THIS IS MY PERSONAL DIRECTORY STRUCTURE
        pathname_Qsi = strcat('/Users/anwlost/Documents/MCM_LTER/MicroMet/snowmodel_ANW/outputs/Qsi/',(filename_Qsi));
        pathname_Qli = strcat('/Users/anwlost/Documents/MCM_LTER/MicroMet/snowmodel_ANW/outputs/Qli/',(filename_Qli));
        pathname_Tair = strcat('/Users/anwlost/Documents/MCM_LTER/MicroMet/snowmodel_ANW/outputs/Tair/',(filename_Tair));
        pathname_rh = strcat('/Users/anwlost/Documents/MCM_LTER/MicroMet/snowmodel_ANW/outputs/rh/',(filename_rh));
        pathname_wspd = strcat('/Users/anwlost/Documents/MCM_LTER/MicroMet/snowmodel_ANW/outputs/wspd/',(filename_wspd));
        M = textread((pathname_Qsi{1}),'%f','headerlines',6); 
        L = textread((pathname_Qli{1}),'%f','headerlines',6); 
        T = textread((pathname_Tair{1}),'%f','headerlines',6); 
        R = textread((pathname_rh{1}),'%f','headerlines',6); 
        W = textread((pathname_wspd{1}),'%f','headerlines',6);
        Qsi = vec2mat(M,200);
        Qli = vec2mat(L,200);
        Tair = vec2mat(T,200);
        rh = vec2mat(R,200);
        wspd = vec2mat(W,200);
        
        % PLOT THE DATA GRIDS AS 5 DIFFERENT PLOTS. 
        figure(1)
        g = pcolor(Xg,Yg,flipud(Qsi));
        set(g,'LineStyle','none')
        ylabel('northing (m)','FontSize',12); xlabel('easting (m)','FontSize',12); 
        c = colorbar; caxis([0 1000]); ylabel(c,'incident sw radiation (W/m^2)','FontSize',12); 
        colormap pink
        title(datestr(current_date),'FontSize',18); 
        
        figure(2)
        g = pcolor(Xg,Yg,flipud(Qli));
        set(g,'LineStyle','none')
        ylabel('northing (m)','FontSize',12); xlabel('easting (m)','FontSize',12);
        c = colorbar; caxis([0 300]); ylabel(c,'incident lw radiation (W/m^2)','FontSize',12); 
        colormap winter
        title(datestr(current_date),'FontSize',18); 
        
        figure(3)
        g = pcolor(Xg,Yg,flipud(Tair));
        set(g,'LineStyle','none')
        ylabel('northing (m)','FontSize',12); xlabel('easting (m)','FontSize',12);
        c = colorbar; caxis([-20 10]); ylabel(c,'air temp (^cC)','FontSize',12);% 
        title(datestr(current_date),'FontSize',18); 
        
        figure(4)
        g = pcolor(Xg,Yg,flipud(rh));
        set(g,'LineStyle','none')
        ylabel('northing (m)','FontSize',12); xlabel('easting (m)','FontSize',12);
        c = colorbar; caxis([0 100]); ylabel(c,'relative humidity (%)','FontSize',12);
        colormap cool
        title(datestr(current_date),'FontSize',18); 
       
        figure(5)
        g = pcolor(Xg,Yg,flipud(wspd));
        set(g,'LineStyle','none')
        ylabel('northing (m)','FontSize',12); xlabel('easting (m)','FontSize',12);
        c = colorbar; caxis([0 30]); ylabel(c,'windspeed (m/s)','FontSize',12);
        title(datestr(current_date),'FontSize',18); 
        
        end
    end
end
end
